﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Settings
{
    public partial class POSSettings : System.Web.UI.Page
    {
        private static WebSettings currSettings;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                LoadPrinters();
                ShowSettingsDetails();
               // LoadTaxDetails();
            }
        }

        private void LoadPrinters()
        {
            foreach (string sPrinters in System.Drawing.Printing.PrinterSettings.InstalledPrinters)
            {
                ddlBarPrinter.Items.Add(sPrinters);
                ddlKitchenPrinter.Items.Add(sPrinters);
                ddlReceiptPrinter.Items.Add(sPrinters);
            }
        }

        private void ShowSettingsDetails()
        {
            currSettings = WebSettingsBL.GetItem(WebSession.SettingsID);
            if (currSettings != null)
            {
                hdSettingsID.Value = currSettings.UniqueID.ToString();
                txtSMTPServer.Text = currSettings.SMTPserver;
                txtSMTPPort.Text = currSettings.SMTPPort.ToString();
                txtSMTPUserName.Text = currSettings.SMTPUserName;
                txtSMTPPassword.Text = currSettings.SMTPpassword;
                txtContactEmail.Text = currSettings.ContactEmailAddress;
                txtSalesEmail.Text = currSettings.SalesEmailAddress;
                txtNoReplyEmail.Text = currSettings.NoReplyEmailAddress;
                txtFromEmail.Text = currSettings.FromEmailAddress;
                txtToEmail.Text = currSettings.ToEmailAddress;
                txtCCEmails.Text = currSettings.CCEmailAddress;
                txtBCCEmail.Text = currSettings.BCCEmailAddress;
                txtCompany.Text = currSettings.CompanyFullName;
                txtCompanyShortName.Text = currSettings.CompanyShortName;
                txtCompanyAddress.Text = currSettings.CompanyAddress;
                if (ddlBarPrinter.Items.FindByText(currSettings.BarPrinter) != null)
                {
                    ddlBarPrinter.Items.FindByText(currSettings.BarPrinter).Selected = true;
                }
                if (ddlReceiptPrinter.Items.FindByText(currSettings.ReceiptPrinter) != null)
                {
                    ddlReceiptPrinter.Items.FindByText(currSettings.ReceiptPrinter).Selected = true;
                }
                if (ddlKitchenPrinter.Items.FindByText(currSettings.KitchenPrinter) != null)
                {
                    ddlKitchenPrinter.Items.FindByText(currSettings.KitchenPrinter).Selected = true;
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                currSettings.UniqueID = WebSession.SettingsID;
                currSettings.Mode = GlobalConfigurations.Mode.Update;

                currSettings.SMTPserver = txtSMTPServer.Text.Trim();
                currSettings.SMTPPort = txtSMTPPort.Text.Trim().Length != 0 ? int.Parse(txtSMTPPort.Text.Trim()) : 0;
                currSettings.SMTPUserName = txtSMTPUserName.Text.Trim();
                currSettings.SMTPpassword = txtSMTPPassword.Text.Trim();
                currSettings.ContactEmailAddress = txtContactEmail.Text.Trim();
                currSettings.SalesEmailAddress = txtSalesEmail.Text.Trim();
                currSettings.NoReplyEmailAddress = txtNoReplyEmail.Text.Trim();
                currSettings.FromEmailAddress = txtFromEmail.Text.Trim();
                currSettings.ToEmailAddress = txtToEmail.Text.Trim();
                currSettings.CCEmailAddress = txtCCEmails.Text.Trim();
                currSettings.BCCEmailAddress = txtBCCEmail.Text.Trim();
                currSettings.CompanyFullName = txtCompany.Text.Trim();
                currSettings.CompanyShortName = txtCompanyShortName.Text.Trim();
                currSettings.CompanyAddress = txtCompanyAddress.Text.Trim();

                if (WebSettingsBL.Save(currSettings))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Settings has been saved successfully.", string.Empty);
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/POSSettings.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtSMTPServer.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtSMTPServer.ClientID + "', 'Please enter valid SMTP Server.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSMTPPort.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtSMTPPort.ClientID + "', 'Please enter valid SMTP Port.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateString(txtSMTPUserName.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtSMTPUserName.ClientID + "', 'Please enter valid SMTP User Name.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateString(txtSMTPPassword.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtSMTPPassword.ClientID + "', 'Please enter valid SMTP Password.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateEmail(txtFromEmail.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtFromEmail.ClientID + "', 'Please enter valid From Email.'); ");
                return false;
            }

            if (txtToEmail.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateEmail(txtToEmail.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtToEmail.ClientID + "', 'Please enter valid To Email.'); ");
                    return false;
                }
            }

            if (txtContactEmail.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateEmail(txtContactEmail.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtContactEmail.ClientID + "', 'Please enter valid Contact Email.'); ");
                    return false;
                }
            }

            if (txtSalesEmail.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateEmail(txtSalesEmail.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtSalesEmail.ClientID + "', 'Please enter valid Sales Email.'); ");
                    return false;
                }
            }

            if (txtNoReplyEmail.Text.Trim().Length != 0)
            {
                if (!ValidationUtility.ValidateEmail(txtNoReplyEmail.Text.Trim()))
                {
                    WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtNoReplyEmail.ClientID + "', 'Please enter valid No Reply Email.'); ");
                    return false;
                }
            }

            if (txtCCEmails.Text.Trim().Length != 0)
            {
                string[] emails = txtCCEmails.Text.Trim().Split(new char[] { ';' });
                foreach (string em in emails)
                {
                    if (!ValidationUtility.ValidateEmail(em))
                    {
                        WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtCCEmails.ClientID + "', 'Some emails entered in CC Emails is not valid.'); ");
                        return false;
                    }
                }
            }

            if (txtBCCEmail.Text.Trim().Length != 0)
            {
                string[] emails = txtBCCEmail.Text.Trim().Split(new char[] { ';' });
                foreach (string em in emails)
                {
                    if (!ValidationUtility.ValidateEmail(em))
                    {
                        WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtBCCEmail.ClientID + "', 'Some emails entered in BCC Emails is not valid.'); ");
                        return false;
                    }
                }
            }

            if (!ValidationUtility.ValidateString(txtCompany.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtCompany.ClientID + "', 'Please enter valid Company Full Name.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateString(txtCompanyShortName.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtCompanyShortName.ClientID + "', 'Please enter valid Company Short Name.'); ");
                return false;
            }

            if (!ValidationUtility.ValidateString(txtCompanyAddress.Text.Trim()))
            {
                WebUtilities.RegisterStartupScript(this, "validationMsgBottom('#" + txtCompanyAddress.ClientID + "', 'Please enter valid Company Address.'); ");
                return false;
            }

            return true;
        }

       
    }
}